#include <cuda_runtime.h>
#include <cublas_v2.h>
#include <iostream>

void do_cuda_stuff(void);

int cuda_devices(void) {
    int result = 0;
    cudaGetDeviceCount(&result);
    return result;
}

int main(void) {
    int n = cuda_devices();
    if (n == 0) {
        std::cout << "No CUDA hardware found. Exiting.\n";
        return 0;
    }

    std::cout << "Found " << n << " CUDA devices.\n";

    do_cuda_stuff();

    cublasHandle_t handle;
    if (cublasCreate(&handle) != CUBLAS_STATUS_SUCCESS) {
        std::cout << "cuBLAS initialization failed. Exiting.\n";
        return -1;
    }

    std::cout << "Initialized cuBLAS\n";
    if (cublasDestroy(handle) != CUBLAS_STATUS_SUCCESS) {
        std::cout << "cuBLAS de-initialization failed. Exiting.\n";
        return -1;
    }

    return 0;
}
